//								EJEMPLO 7
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Mquina de envasado. eliminacin de rebotes mediante una temporizacin.
//
//Dos rels "M1" (RB0) y "M2" (RB1) gobiernan dos motores que arrastran dos cintas 
//transportadoras. "M1" (RB0) transporta piezas y "M2" (RB1) embalajes. Un sensor "DP" (RA1) 
//detecta el paso de piezas y, otro "DE" (RA2), detecta el correcto posicionamiento de un 
//envase. Al detectarse el paso de 10 piezas, el envase se considera lleno, se activa una 
//seal acstica "A" (RB2) y, la cinta que transporta embalajes, se desplaza hasta situar un 
//nuevo envase vaco. En este momento se desactiva la seal acstica "A"(RB2) y nuevamente 
//avanza la cinta de piezas repitindose as el ciclo. Un interruptor "I" (RA0) activa o 
//no a todo el sistema.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use delay(clock=4000000) //Activa las temporizaciones en base al clock de trabajo
#use fast_io (A)
#use fast_io (B)

int	x;				//Variable para el contador de piezas

main()
{
  	output_b(0x0);					//Borra las salidas
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida

	  while(1)
 	{   while(!input(PIN_A0));	//Esperar a que se active I
	   	output_low(PIN_B2);		//Desactiva acstico A
		output_high(PIN_B1);    // Activar cinta de envases M2
		
		while(!input(PIN_A2));	// Espera se posicione el nuevo envase
		delay_ms(10);			//Temporiza 10 ms para eliminar rebotes
		output_low(PIN_B1);		// Desactiva cinta de envases M2
		output_high(PIN_B0);	// Activa cinta de piezas M1
	
		for (x=1; x<=10; ++x)	//Bucle para contar 10 piezas
				{
				while(input(PIN_A1));
				delay_ms(10);			//Temporiza 10 ms para eliminar rebotes
				while(!input(PIN_A1)); //Esperar que pase pieza por DP (1-0-1
				delay_ms(10);			//Temporiza 10 ms para eliminar rebotes
				}
		
		output_low(PIN_B0);		//Desactiva cinta de piezas M1
		output_high(PIN_B2);	//Activa seal acstica A
		output_high(PIN_B1);	//Activa cinta de envases M2
		
		while(input(PIN_A2));	//Espera salida de envase lleno
		delay_ms(10);			//Temporiza 10 ms para eliminar rebotes
	}	
}

